<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Slider extends Model 
{

    protected $table = 'sliders';
    public $timestamps = true;
    protected $fillable = array('title', 'description', 'path', 'file_name', 'file_size', 'order', 'lang', 'page_id', 'article_id', 'blog_post_id');
    protected $visible = array('title', 'description', 'path', 'file_name', 'file_size', 'order', 'lang', 'page_id', 'article_id', 'blog_post_id');

    public function page()
    {
        return $this->belongsToMany('App\Models\Page');
    }

    public function blogpost()
    {
        return $this->belongsToMany('App\Models\BlogPosts');
    }

    public function article()
    {
        return $this->belongsToMany('App\Models\Article');
    }

}